/*--------------------------------------------------------------*
 *	UniMate Value Added API Sample
 *	2015-08-13
 *--------------------------------------------------------------*/

#include "Value_Added_API.h"

#if (defined(_WIN32) || defined(_WIN64))
#include <windows.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define MAXLEN  1020

CALLBACKFUNC pfnCallback;

/* Callback function to show the processing
 */
int outputMsg(unsigned long Type, unsigned long position)
{
	printf("\rCurrent type %08x, position %d.%d%%%",Type, position/10, position%10);
	return 0;
}

void writeISO()
{
	UMD_HANDLE handle[32];
	unsigned long deviceCount = 0;
	UMD_RV ret;
	char fileName[MAXLEN];
	char adminPin[MAXLEN];
	unsigned long currentAttempts=0;
	
	/* Set the callback function
	 */
	pfnCallback = outputMsg;

	/* Get list of slots containing UniMate
	 */
	ret = UMD_Find(handle, &deviceCount); 
	if (ret == 0 && deviceCount > 0)
	{
		printf("Input Admin Pin:\n");
		scanf("%s", adminPin);
		/* Log on Admin to write iso file
		 */
		ret = UMD_AdminLogin(handle[0], (unsigned char*)adminPin, strlen(adminPin), &currentAttempts);
		if(ret != 0)
		{
			printf("\n	UMD_AdminLogin returned:		%08x\n", ret);
			return;
		}

		printf("Input ISO File:\n");
		scanf("%s", fileName);
		
		/* Write the iso file to the first UniMate
		 */
		ret = UMD_WriteISO(handle[0], fileName);
		if(ret != 0)
		{
			printf("\n	UMD_WriteISOFile returned:		%08x\n", ret);
		}
		else
		{
			printf("\n	UMD_WriteISOFile Successed\n");
		}
	}
	else if(deviceCount == 0)
	{
		printf("No UniMate is available.\n");
	}
	printf("\n");
	return;
}

void changeLanguage()
{
	unsigned long snFnv[32];
	unsigned long deviceCount = 0;
	unsigned long ret;
	unsigned long i;
	char fileName[MAXLEN];
	pfnCallback = outputMsg;
	int language = 0;
	unsigned char sw[258];
	unsigned long outLen=0;
		
	ret = UMD_Find(snFnv, &deviceCount); 
	if (ret == 0 && deviceCount > 0)
	{
		for (i=0; i< deviceCount; i++)
		{
			printf("Input Language Mode: 0=English, 1=Chinese, 2=Japanese\n");
			scanf("%d", &language);
			
			ret = UMD_SetLanguage(snFnv[0], language);
			if(ret != 0)
			{
				printf("	UMD_SetLanguage returned:		%08x\n", ret);
			}
			else
			{
				printf("	UMD_SetLanguage Successed\n");
			}
			
		}
		printf("******************************************************\n");
		
	}
	else if(deviceCount == 0)
	{
		printf("No UniMate is available.\n");
	}
	printf("\n");
	
	return;
}

int main(int argc, int* argv[])
{
	int userSelect;

	UMD_Initialize();
	
	while(1) 
	{
		printf("---------UniMate Value Added Sample---------\n");
		printf("1: Write ISO File\n");
		printf("2: Change Language Mode\n");
		printf("0: exit\n");
		printf("----------------------------------------------\n");
		printf("Input Select:");
		scanf("%d", &userSelect);
		printf("\n");
		switch (userSelect)
		{
		case 0:
			printf("***********************Finished***********************\n");
			UMD_Finalize();
			return 0;

		case 1:
			writeISO();
			break;

		case 2:
			changeLanguage();
			break;

		default:
			break;
		}
	};

	UMD_Finalize();
	return 0;
}